/**
* \file: filedb_writer.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef AAM_APP_IFACE_FILEDB_WRITER_H
#define AAM_APP_IFACE_FILEDB_WRITER_H

#include "model/device.h"
#include "model/partition.h"

error_code_t filedb_writer_init(void);

void filedb_writer_deinit(void);

void filedb_writer_signal_device_detected(device_t *device);

void filedb_writer_signal_device_handled(device_t *device);

void filedb_writer_signal_device_invalid(device_t *device);



void filedb_writer_signal_partition_handled(partition_t *partition);

void filedb_writer_signal_partition_invalid(partition_t *partition);

#endif
